@extends('karyawan.layout.master')

@section('title', 'Pengajuan')

@push('styles')
<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', sans-serif;
    }

    body {
        margin: 0;
        padding: 0;
        background: #ffffff;
        overflow: hidden;
    }

    .fullscreen-wrapper {
        position: fixed;
        /* margin-top: 30px; */
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        display: flex;
        flex-direction: column;
        background: #f8f9fa;
    }

    /* Tab Navigation */
    .tab-navigation {
        background: white;
        border-bottom: 2px solid #e9ecef;
        display: flex;
        flex-shrink: 0;
    }

    .tab-nav-item {
        flex: 1;
        padding: 16px;
        text-align: center;
        cursor: pointer;
        border: none;
        background: none;
        color: #6c757d;
        font-weight: 600;
        font-size: 15px;
        position: relative;
        transition: all 0.3s;
    }

    .tab-nav-item.active {
        color: #354591;
    }

    .tab-nav-item.active::after {
        content: '';
        position: absolute;
        bottom: -2px;
        left: 0;
        right: 0;
        height: 2px;
        background: #354591;
    }

    .tab-nav-item i {
        margin-right: 6px;
    }

    /* Scrollable Content */
    .pengajuan-content {
        flex: 1;
        margin-top: 30px;
        overflow-y: auto;
        -webkit-overflow-scrolling: touch;
        padding-bottom: 100px;
    }

    /* Tab Content */
    .tab-content {
        display: none;
    }

    .tab-content.active {
        display: block;
    }

    /* Alert Messages */
    .alert-container {
        padding: 15px 20px;
        background: white;
        flex-shrink: 0;
    }

    .alert {
        padding: 12px 15px;
        border-radius: 8px;
        font-size: 14px;
        display: flex;
        align-items: center;
        gap: 10px;
        margin-bottom: 10px;
    }

    .alert-success {
        background: #d4edda;
        color: #155724;
        border-left: 4px solid #28a745;
    }

    .alert-danger {
        background: #f8d7da;
        color: #721c24;
        border-left: 4px solid #dc3545;
    }

    .alert-info {
        background: #d1ecf1;
        color: #0c5460;
        border-left: 4px solid #17a2b8;
    }

    /* Cards */
    .jatah-cuti-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 15px;
        padding: 25px 20px;
        color: white;
        margin: 20px;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
    }

    .shift-aktif-card {
        background: linear-gradient(135deg, #354591 0%, #4a5db8 100%);
        border-radius: 15px;
        padding: 25px 20px;
        color: white;
        margin: 20px;
        box-shadow: 0 4px 15px rgba(53, 69, 145, 0.3);
    }

    .card-header {
        font-size: 14px;
        opacity: 0.9;
        margin-bottom: 5px;
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .card-title {
        font-size: 20px;
        font-weight: 700;
        margin-bottom: 20px;
    }

    .card-stats {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 12px;
    }

    .card-stats.shift-stats {
        grid-template-columns: repeat(2, 1fr);
    }

    .stat-item {
        text-align: center;
        padding: 15px 10px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 12px;
        backdrop-filter: blur(10px);
        border: 1px solid rgba(255, 255, 255, 0.3);
    }

    .stat-value {
        font-size: 28px;
        font-weight: 700;
        margin-bottom: 5px;
        text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    .stat-value.medium {
        font-size: 18px;
    }

    .stat-label {
        font-size: 11px;
        opacity: 0.9;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        font-weight: 600;
    }

    /* Section Card */
    .section-card {
        background: white;
        margin: 0 20px 20px;
        border-radius: 15px;
        padding: 20px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
    }

    .section-header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 20px;
    }

    .section-title {
        font-size: 18px;
        font-weight: 700;
        color: #2d3748;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .section-title.cuti i {
        color: #FF6B35;
    }

    .section-title.shift i {
        color: #354591;
    }

    .view-all {
        font-size: 13px;
        font-weight: 600;
        text-decoration: none;
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .view-all.cuti {
        color: #FF6B35;
    }

    .view-all.shift {
        color: #354591;
    }

    /* Item Cards */
    .cuti-item {
        background: #f8f9fa;
        border-radius: 12px;
        padding: 15px;
        margin-bottom: 15px;
        border-left: 4px solid #FF6B35;
        transition: all 0.3s;
    }

    .shift-req-item {
        background: #f8f9fa;
        border-radius: 12px;
        padding: 15px;
        margin-bottom: 15px;
        border-left: 4px solid #354591;
        transition: all 0.3s;
    }

    .cuti-item:hover,
    .shift-req-item:hover {
        transform: translateX(5px);
    }

    .item-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 12px;
    }

    .item-type {
        font-size: 16px;
        font-weight: 700;
        color: #2d3748;
    }

    .item-status {
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .item-status.pending {
        background: #fef3c7;
        color: #92400e;
    }

    .item-status.disetujui {
        background: #d1fae5;
        color: #065f46;
    }

    .item-status.ditolak {
        background: #fee2e2;
        color: #991b1b;
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 40px 20px;
    }

    .empty-icon {
        font-size: 64px;
        color: #e2e8f0;
        margin-bottom: 15px;
    }

    .empty-text {
        color: #9ca3af;
        font-size: 14px;
        font-weight: 500;
    }

    /* Approval Progress */
    .approval-progress {
        margin-top: 12px;
        padding-top: 12px;
        border-top: 1px solid #e2e8f0;
    }

    .progress-title {
        font-size: 12px;
        color: #718096;
        margin-bottom: 12px;
        font-weight: 600;
    }

    .progress-steps {
        display: flex;
        align-items: center;
        gap: 8px;
        position: relative;
    }

    .progress-step {
        flex: 1;
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 6px;
        position: relative;
    }

    .step-connector {
        position: absolute;
        top: 16px;
        left: calc(50% + 20px);
        right: calc(-50% + 20px);
        height: 2px;
        background: #e2e8f0;
        z-index: 0;
    }

    .step-connector.completed {
        background: #10b981;
    }

    .progress-step:last-child .step-connector {
        display: none;
    }

    .step-icon {
        width: 32px;
        height: 32px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
        font-weight: 700;
        transition: all 0.3s;
        position: relative;
        z-index: 1;
        border: 2px solid transparent;
    }

    .step-icon.completed {
        background: #10b981;
        color: white;
        box-shadow: 0 2px 8px rgba(16, 185, 129, 0.3);
    }

    .step-icon.current {
        background: #f59e0b;
        color: white;
        animation: pulse 2s infinite;
        box-shadow: 0 2px 8px rgba(245, 158, 11, 0.3);
    }

    .step-icon.pending {
        background: #f3f4f6;
        color: #9ca3af;
        border-color: #e5e7eb;
    }

    .step-icon.rejected {
        background: #ef4444;
        color: white;
        box-shadow: 0 2px 8px rgba(239, 68, 68, 0.3);
    }

    @keyframes pulse {
        0%, 100% {
            transform: scale(1);
            box-shadow: 0 2px 8px rgba(245, 158, 11, 0.3);
        }
        50% {
            transform: scale(1.05);
            box-shadow: 0 4px 12px rgba(245, 158, 11, 0.5);
        }
    }

    .step-label {
        font-size: 10px;
        font-weight: 600;
        text-align: center;
        color: #718096;
        text-transform: uppercase;
        letter-spacing: 0.3px;
    }

    /* Floating Action Button with Dropdown */
    .fab-container {
        margin-bottom: 10px;
        position: fixed;
        bottom: 80px;
        right: 20px;
        z-index: 999;
    }

    .fab-overlay {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.3);
        z-index: 998;
    }

    .fab-overlay.show {
        display: block;
    }

    .fab-menu {
        position: absolute;
        bottom: 75px;
        right: 0;
        background: white;
        border-radius: 12px;
        box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
        padding: 8px;
        min-width: 220px;
        opacity: 0;
        transform: translateY(20px) scale(0.8);
        transform-origin: bottom right;
        transition: all 0.3s cubic-bezier(0.68, -0.55, 0.265, 1.55);
        pointer-events: none;
    }

    .fab-menu.show {
        opacity: 1;
        transform: translateY(0) scale(1);
        pointer-events: all;
    }

    .fab-menu-item {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 14px 16px;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.2s;
        text-decoration: none;
        color: inherit;
        border: none;
        background: none;
        width: 100%;
        text-align: left;
    }

    .fab-menu-item:hover {
        background: #f8f9fa;
    }

    .fab-menu-item:active {
        transform: scale(0.98);
    }

    .fab-menu-icon {
        width: 40px;
        height: 40px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 18px;
        color: white;
        flex-shrink: 0;
    }

    .fab-menu-icon.cuti {
        background: linear-gradient(135deg, #FF6B35 0%, #F7931E 100%);
    }

    .fab-menu-icon.shift {
        background: linear-gradient(135deg, #354591 0%, #4a5db8 100%);
    }

    .fab-menu-content {
        flex: 1;
    }

    .fab-menu-title {
        font-size: 15px;
        font-weight: 700;
        color: #2d3748;
        margin-bottom: 2px;
    }

    .fab-menu-desc {
        font-size: 12px;
        color: #718096;
    }

    .fab-button {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border: none;
        font-size: 24px;
        cursor: pointer;
        box-shadow: 0 4px 20px rgba(102, 126, 234, 0.4);
        transition: all 0.3s;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .fab-button:hover {
        transform: translateY(-3px) rotate(90deg);
        box-shadow: 0 6px 25px rgba(102, 126, 234, 0.5);
    }

    .fab-button.active {
        transform: rotate(45deg);
        background: linear-gradient(135deg, #764ba2 0%, #667eea 100%);
    }

    .fab-button:active {
        transform: scale(0.95);
    }

    /* Responsive */
    @media (max-width: 768px) {
        .jatah-cuti-card,
        .shift-aktif-card {
            padding: 20px 15px;
            margin: 15px;
        }

        .card-title {
            font-size: 18px;
        }

        .stat-value {
            font-size: 24px;
        }

        .section-card {
            margin: 0 15px 15px;
            padding: 15px;
        }

        .fab-button {
            width: 56px;
            height: 56px;
            font-size: 22px;
        }

        .fab-container {
            bottom: 75px;
            right: 15px;
        }

        .fab-menu {
            bottom: 70px;
        }
    }

    @media (max-width: 480px) {
        .card-stats {
            gap: 10px;
        }

        .stat-value {
            font-size: 22px;
        }

        .stat-label {
            font-size: 10px;
        }

        .progress-step {
            gap: 4px;
        }

        .step-icon {
            width: 28px;
            height: 28px;
            font-size: 12px;
        }

        .step-connector {
            top: 14px;
        }

        .step-label {
            font-size: 9px;
        }
    }
</style>
@endpush

@section('content')
<div class="fullscreen-wrapper">
    {{-- Alert Messages --}}


    {{-- Tab Navigation --}}
    <div class="tab-navigation">
        <button class="tab-nav-item active" data-tab="cuti">
            <i class="fas fa-calendar-alt"></i> Pengajuan Cuti
        </button>
        @if(in_array(auth()->user()->role, ['admin', 'manager', 'gm', 'hrd']))
        <button class="tab-nav-item" data-tab="shift">
            <i class="fas fa-sync-alt"></i> Pengajuan Shift
        </button>
        @endif
    </div>

    {{-- Scrollable Content --}}
    <div class="pengajuan-content">
        {{-- TAB: Pengajuan Cuti --}}
        <div class="tab-content active" id="tab-cuti">
            {{-- Jatah Cuti Card --}}
            <div class="jatah-cuti-card">
                <div class="card-header">
                    <i class="fas fa-calendar-alt"></i>
                    Tahun {{ now()->year }}
                </div>
                <div class="card-title">Jatah Cuti Anda</div>
                <div class="card-stats">
                    <div class="stat-item">
                        <div class="stat-value">{{ $jatahCuti->jatah ?? 0 }}</div>
                        <div class="stat-label">Sisa</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-value">{{ ($jatahCuti->jatah_awal ?? 12) - ($jatahCuti->jatah ?? 0) }}</div>
                        <div class="stat-label">Terpakai</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-value">{{ $jatahCuti->jatah_awal ?? 12 }}</div>
                        <div class="stat-label">Total</div>
                    </div>
                </div>
            </div>

            {{-- Cuti Aktif --}}
            @if($cutiAktif && count($cutiAktif) > 0)
            <div class="section-card">
                <div class="section-header">
                    <div class="section-title cuti">
                        <i class="fas fa-clock"></i>
                        <span>Pengajuan Aktif</span>
                    </div>
                </div>

                @foreach($cutiAktif as $item)
                <div class="cuti-item">
                    <div class="item-header">
                        <div class="item-type">{{ $item->jenisCuti->nama ?? 'Cuti' }}</div>
                        <div class="item-status {{ $item->status }}">
                            {{ ucfirst($item->status) }}
                        </div>
                    </div>

                    <div style="font-size: 13px; color: #718096; display: flex; align-items: center; gap: 8px; margin-bottom: 12px;">
                        <i class="far fa-calendar"></i>
                        {{ $item->tanggal_mulai->format('d M Y') }} - {{ $item->tanggal_selesai->format('d M Y') }}
                        <span style="font-weight: 600;">({{ $item->jumlah_hari }} hari)</span>
                    </div>

                    @if($item->approvals && count($item->approvals) > 0)
                    <div class="approval-progress">
                        <div class="progress-title">
                            <i class="fas fa-tasks"></i>
                            Progress Persetujuan
                        </div>
                        <div class="progress-steps">
                            @foreach($item->approvals as $index => $approval)
                                <div class="progress-step">
                                    @if($index < count($item->approvals) - 1)
                                        <div class="step-connector {{ $approval->status === 'disetujui' ? 'completed' : '' }}"></div>
                                    @endif

                                    <div class="step-icon {{ $approval->status === 'disetujui' ? 'completed' : ($approval->step === $item->current_step ? 'current' : ($approval->status === 'ditolak' ? 'rejected' : 'pending')) }}">
                                        @if($approval->status === 'disetujui')
                                            <i class="fas fa-check"></i>
                                        @elseif($approval->status === 'ditolak')
                                            <i class="fas fa-times"></i>
                                        @elseif($approval->step === $item->current_step)
                                            <i class="fas fa-hourglass-half"></i>
                                        @else
                                            {{ $index + 1 }}
                                        @endif
                                    </div>
                                    <div class="step-label">{{ $approval->role_label }}</div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    @endif
                </div>
                @endforeach
            </div>
            @endif

            {{-- Cuti Selesai --}}
            @if($cutiSelesai && count($cutiSelesai) > 0)
            <div class="section-card">
                <div class="section-header">
                    <div class="section-title cuti">
                        <i class="fas fa-history"></i>
                        <span>Riwayat Terbaru</span>
                    </div>
                    <a href="{{ route('karyawan.pengajuan.riwayat') }}" class="view-all cuti">
                        Lihat Semua
                        <i class="fas fa-chevron-right"></i>
                    </a>
                </div>

                @foreach($cutiSelesai->take(3) as $item)
                <div class="cuti-item">
                    <div class="item-header">
                        <div class="item-type">{{ $item->jenisCuti->nama ?? 'Cuti' }}</div>
                        <div class="item-status {{ $item->status }}">
                            {{ ucfirst($item->status) }}
                        </div>
                    </div>

                    <div style="font-size: 13px; color: #718096; display: flex; align-items: center; gap: 8px;">
                        <i class="far fa-calendar"></i>
                        {{ $item->tanggal_mulai->format('d M Y') }} - {{ $item->tanggal_selesai->format('d M Y') }}
                        <span style="font-weight: 600;">({{ $item->jumlah_hari }} hari)</span>
                    </div>
                </div>
                @endforeach
            </div>
            @endif

            {{-- Empty State Cuti --}}
            @if((!$cutiAktif || count($cutiAktif) === 0) && (!$cutiSelesai || count($cutiSelesai) === 0))
            <div class="section-card">
                <div class="empty-state">
                    <div class="empty-icon">
                        <i class="far fa-calendar-times"></i>
                    </div>
                    <div class="empty-text">Belum ada pengajuan cuti</div>
                </div>
            </div>
            @endif
        </div>

        {{-- TAB: Pengajuan Shift (Only for Admin Roles) --}}
        @if(in_array(auth()->user()->role, ['admin', 'manager', 'gm', 'hrd']))
        <div class="tab-content" id="tab-shift">
            {{-- Shift Aktif Card --}}
            @if(isset($jadwalShiftAktif) && $jadwalShiftAktif)
            <div class="shift-aktif-card">
                <div class="card-header">
                    <i class="fas fa-building"></i>
                    Departemen {{ auth()->user()->karyawan->departemen->nama ?? '-' }}
                </div>
                <div class="card-title">Shift Saat Ini</div>
                <div class="card-stats shift-stats">
                    <div class="stat-item">
                        <div class="stat-label">Kode / Jenis</div>
                        <div class="stat-value medium">{{ $jadwalShiftAktif->shift->kode }}</div>
                        <div class="stat-label">{{ $jadwalShiftAktif->shift->jenis }}</div>
                    </div>
                    <div class="stat-item">
                        <div class="stat-label">Jam Kerja</div>
                        <div class="stat-value medium">{{ substr($jadwalShiftAktif->shift->jam_masuk, 0, 5) }}</div>
                        <div class="stat-label">{{ substr($jadwalShiftAktif->shift->jam_pulang, 0, 5) }}</div>
                    </div>
                </div>
            </div>
            @endif

            {{-- Shift Aktif --}}
            @if(isset($shiftAktif) && count($shiftAktif) > 0)
            <div class="section-card">
                <div class="section-header">
                    <div class="section-title shift">
                        <i class="fas fa-clock"></i>
                        <span>Pengajuan Aktif</span>
                    </div>
                </div>

                @foreach($shiftAktif as $item)
                <div class="shift-req-item">
                    <div class="item-header">
                        <div class="item-type">
                            <i class="fas fa-sync-alt"></i>
                            Pergantian {{ ucfirst($item->jenis) }}
                        </div>
                        <div class="item-status {{ $item->status }}">
                            {{ ucfirst($item->status) }}
                        </div>
                    </div>

                    <div style="display: flex; align-items: center; gap: 10px; margin-bottom: 8px;">
                        <span style="padding: 6px 12px; background: #e2e8f0; border-radius: 6px; font-weight: 600; font-size: 14px;">
                            {{ $item->shiftLama->jenis ?? '-' }}
                        </span>
                        <span style="color: #354591; font-weight: 700;"><i class="fas fa-arrow-right"></i></span>
                        <span style="padding: 6px 12px; background: #d1fae5; border-radius: 6px; font-weight: 700; color: #065f46; font-size: 14px;">
                            {{ $item->shiftBaru->jenis ?? '-' }}
                        </span>
                    </div>

                    <div style="font-size: 13px; color: #718096; display: flex; align-items: center; gap: 8px;">
                        <i class="far fa-calendar"></i>
                        {{ \Carbon\Carbon::parse($item->tanggal_mulai)->format('d M Y') }}
                        @if($item->tanggal_selesai)
                            - {{ \Carbon\Carbon::parse($item->tanggal_selesai)->format('d M Y') }}
                        @else
                            - Seterusnya
                        @endif
                    </div>
                </div>
                @endforeach
            </div>
            @endif

            {{-- Shift Selesai --}}
            @if(isset($shiftSelesai) && count($shiftSelesai) > 0)
            <div class="section-card">
                <div class="section-header">
                    <div class="section-title shift">
                        <i class="fas fa-history"></i>
                        <span>Riwayat Terbaru</span>
                    </div>
                    <a href="{{ route('karyawan.ajukan-shift.riwayat') }}" class="view-all shift">
                        Lihat Semua
                        <i class="fas fa-chevron-right"></i>
                    </a>
                </div>

                @foreach($shiftSelesai->take(3) as $item)
                <div class="shift-req-item">
                    <div class="item-header">
                        <div class="item-type">
                            <i class="fas fa-sync-alt"></i>
                            Pergantian {{ ucfirst($item->jenis) }}
                        </div>
                        <div class="item-status {{ $item->status }}">
                            {{ ucfirst($item->status) }}
                        </div>
                    </div>

                    <div style="display: flex; align-items: center; gap: 10px; margin-bottom: 8px;">
                        <span style="padding: 6px 12px; background: #e2e8f0; border-radius: 6px; font-weight: 600; font-size: 14px;">
                            {{ $item->shiftLama->jenis ?? '-' }}
                        </span>
                        <span style="color: #354591; font-weight: 700;"><i class="fas fa-arrow-right"></i></span>
                        <span style="padding: 6px 12px; background: #d1fae5; border-radius: 6px; font-weight: 700; color: #065f46; font-size: 14px;">
                            {{ $item->shiftBaru->jenis ?? '-' }}
                        </span>
                    </div>

                    <div style="font-size: 13px; color: #718096; display: flex; align-items: center; gap: 8px;">
                        <i class="far fa-calendar"></i>
                        {{ \Carbon\Carbon::parse($item->tanggal_mulai)->format('d M Y') }}
                        @if($item->tanggal_selesai)
                            - {{ \Carbon\Carbon::parse($item->tanggal_selesai)->format('d M Y') }}
                        @else
                            - Seterusnya
                        @endif
                    </div>
                </div>
                @endforeach
            </div>
            @endif

            {{-- Empty State Shift --}}
            @if((!isset($shiftAktif) || count($shiftAktif) === 0) && (!isset($shiftSelesai) || count($shiftSelesai) === 0))
            <div class="section-card">
                <div class="empty-state">
                    <div class="empty-icon">
                        <i class="far fa-clock"></i>
                    </div>
                    <div class="empty-text">Belum ada pengajuan shift</div>
                </div>
            </div>
            @endif
        </div>
        @endif
    </div>

    {{-- Floating Action Button with Dropdown --}}
    <div class="fab-overlay" id="fabOverlay" onclick="toggleFabMenu()"></div>
    <div class="fab-container">
        <div class="fab-menu" id="fabMenu">
            <a href="{{ route('karyawan.pengajuan.create') }}" class="fab-menu-item">
                <div class="fab-menu-icon cuti">
                    <i class="fas fa-calendar-alt"></i>
                </div>
                <div class="fab-menu-content">
                    <div class="fab-menu-title">Ajukan Cuti</div>
                    <div class="fab-menu-desc">Buat pengajuan cuti baru</div>
                </div>
            </a>

            @if(in_array(auth()->user()->role, ['admin', 'manager', 'gm', 'hrd']))
            <a href="{{ route('karyawan.ajukan-shift.create') }}" class="fab-menu-item">
                <div class="fab-menu-icon shift">
                    <i class="fas fa-sync-alt"></i>
                </div>
                <div class="fab-menu-content">
                    <div class="fab-menu-title">Ganti Shift</div>
                    <div class="fab-menu-desc">Ajukan pergantian shift</div>
                </div>
            </a>
            @endif
        </div>

        <button class="fab-button" id="fabButton" onclick="toggleFabMenu()">
            <i class="fas fa-plus"></i>
        </button>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Tab Switching
document.querySelectorAll('.tab-nav-item').forEach(tab => {
    tab.addEventListener('click', function() {
        const targetTab = this.dataset.tab;

        // Update active tab button
        document.querySelectorAll('.tab-nav-item').forEach(t => t.classList.remove('active'));
        this.classList.add('active');

        // Update active content
        document.querySelectorAll('.tab-content').forEach(content => {
            content.classList.remove('active');
        });
        document.getElementById('tab-' + targetTab).classList.add('active');
    });
});

// FAB Menu Toggle
function toggleFabMenu() {
    const fabMenu = document.getElementById('fabMenu');
    const fabButton = document.getElementById('fabButton');
    const fabOverlay = document.getElementById('fabOverlay');

    const isActive = fabMenu.classList.contains('show');

    if (isActive) {
        fabMenu.classList.remove('show');
        fabButton.classList.remove('active');
        fabOverlay.classList.remove('show');
    } else {
        fabMenu.classList.add('show');
        fabButton.classList.add('active');
        fabOverlay.classList.add('show');
    }
}

document.addEventListener('DOMContentLoaded', function() {
    // Auto-hide alerts after 4 seconds
    setTimeout(() => {
        const alertContainer = document.querySelector('.alert-container');
        if (alertContainer) {
            alertContainer.style.transition = 'opacity 0.3s';
            alertContainer.style.opacity = '0';
            setTimeout(() => alertContainer.remove(), 300);
        }
    }, 4000);

    // Touch feedback for FAB
    const fab = document.querySelector('.fab-button');
    if (fab) {
        fab.addEventListener('touchstart', () => {
            if (!fab.classList.contains('active')) {
                fab.style.transform = 'scale(0.95)';
            }
        });
        fab.addEventListener('touchend', () => {
            if (!fab.classList.contains('active')) {
                fab.style.transform = '';
            }
        });
    }
});
</script>
@endpush
